cd $PSScriptRoot

Write-Host "Checking for port config"
$DefaultPort = 5201
$Time = 30
$PortConfigFile = Get-ChildItem -Filter "*.port"
if ($PortConfigFile.Count -gt 0){
    $Port = $PortConfigFile[0].Name.Split('.')[0]
    if ($Port -match "^[\d\.]+$"){
        Write-Host "   -> Config file found, port set to $Port." -ForegroundColor Green
    }
    else{
        $Port = $DefaultPort
        Write-Host "   -> Config file found, but not well formatted. Port defaulting to $Port. Remember you can add a xxxx.port-File in the directory to set it to port xxxx." -ForegroundColor Red
    }
}
else{
    $Port = $DefaultPort
    Write-Host "   -> No Config file found, port defaulting to $Port. Remember you can add a xxxx.port-File in the directory to set it to port xxxx." -ForegroundColor Yellow
}
Write-Host ""
$Server = Read-Host -Prompt "Server to connect to (Hostname, IPv4, IPv6)"

Write-Host "Starting iPerf."
Write-Host "Testing Client -> Server (Upload). This will take about $($Time)s."
.\iperf3.exe -c $Server -p $Port -t $Time --logfile "$($PSScriptRoot)\logfile.txt"
Write-Host "Done."
Write-Host "Testing Server -> Client (Download). This will again take about $($Time)s."
.\iperf3.exe -c $Server -p $Port -t $Time --reverse --logfile "$($PSScriptRoot)\logfile.txt"
Write-Host "Done."

Start-Process "$([System.Environment]::SystemDirectory)\notepad.exe" -ArgumentList "$($PSScriptRoot)\logfile.txt"