# Self-elevate the script if required
if (-Not ([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole] 'Administrator')) {
 if ([int](Get-CimInstance -Class Win32_OperatingSystem | Select-Object -ExpandProperty BuildNumber) -ge 6000) {
  $CommandLine = "-File `"" + $MyInvocation.MyCommand.Path + "`" " + $MyInvocation.UnboundArguments
  Start-Process -FilePath PowerShell.exe -Verb Runas -ArgumentList $CommandLine
  Exit
 }
}


Write-Host "Firewallcheck"
$iCountInboundRules = 0
$iCountInboundRules = (Get-NetFirewallRule | Where { $_.DisplayName -like "iPerf*" -and $_.Direction -eq "Inbound" -and $_.Action -eq "Allow"} | measure).Count
if($iCountInboundRules -gt 0){
	Write-Host "   -> Deleting Inbound Firewall Rules..." -ForegroundColor Cyan
    Get-NetFirewallRule | Where { $_.DisplayName -like "iPerf*" -and $_.Direction -eq "Inbound" -and $_.Action -eq "Allow"} | Remove-NetFirewallRule
	Write-Host "   -> Inbound Firewall Rule added." -ForegroundColor Green
}
else{
    Write-Host "   -> No Firewall Rules found." -ForegroundColor Green
}
Write-Host "Firewallcheck done."